<?php
/* --------------------------------------------------------------
   StorageOfSingleTrackingCodeRequested.php 2020-03-25
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\TrackingCode\Events;

use Gambio\Admin\TrackingCode\Interfaces\TrackingCode;

/**
 * Class StorageOfSingleTrackingCodeRequested
 *
 * @package Gambio\Admin\TrackingCode\Events
 */
class StorageOfSingleTrackingCodeRequested
{
    /**
     * @var TrackingCode
     */
    private $trackingCode;
    
    
    /**
     * StorageOfSingleTrackingCodeRequested constructor.
     *
     * @param TrackingCode $trackingCode
     */
    private function __construct(TrackingCode $trackingCode)
    {
        $this->trackingCode = $trackingCode;
    }
    
    
    /**
     * @param TrackingCode $trackingCode
     *
     * @return StorageOfSingleTrackingCodeRequested
     */
    public static function create(TrackingCode $trackingCode): StorageOfSingleTrackingCodeRequested
    {
        return new self($trackingCode);
    }
    
    
    /**
     * @return TrackingCode
     */
    public function trackingCode(): TrackingCode
    {
        return $this->trackingCode;
    }
    
    
    /**
     * @param TrackingCode $trackingCode
     */
    public function replaceTrackingCode(TrackingCode $trackingCode): void
    {
        $this->trackingCode = $trackingCode;
    }
}